/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.activate;

import com.ibm.hwmca.base.activate.ActivateErrorIDs;
import com.ibm.hwmca.base.activate.ActivationCTData;
import com.ibm.hwmca.base.activate.ActivationDataForApp;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.List;

public class ActivationCT
extends Task
implements ActivateErrorIDs {
    private static final String TRACE_MASKT = "XACTCT T";
    private static final String TRACE_MASKF = "XACTCT F";
    private static final String TRACE_MASKD = "XACTCT D";
    private static final String INTERFACE_NAME = "com.ibm.hwmca.base.activate.Activation";

    public ActivationCT(String name, UIInfo uiInfo) {
        super(name, uiInfo);
        Trace.trace(TRACE_MASKT, "<> ActivationCT(name = " + name + ") ");
    }

    public List checkTargets(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.checkTargets(PresentationTaskParms)");
        ActivationCTData actd = new ActivationCTData();
        ArrayList activationGroupTargetLists = new ArrayList();
        ArrayList badTargetsList = new ArrayList();
        actd.getGoodBadTargets(parms, activationGroupTargetLists, badTargetsList, this);
        actd.setTargetData(activationGroupTargetLists);
        Trace.trace(TRACE_MASKT, "<- ActivationCT.checkTargets() ");
        return badTargetsList;
    }

    public ManagedObject[] checkSecondaryTargets(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.checkSecondaryTargets() ");
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        ActivationCTData actd = new ActivationCTData();
        ArrayList targetData = actd.getTargetData(parms);
        ArrayList<ManagedObject> secondaryObjects = new ArrayList<ManagedObject>();
        ObjectId[] oids = parms.getTargetIds();
        ManagedObject[] targets = new ManagedObject[oids.length];
        int j = 0;
        while (j < oids.length) {
            HwmcaObject ho = mom.get(oids[j]);
            if (ho instanceof ManagedObject) {
                Trace.trace(TRACE_MASKT, " object [" + j + "] is a managed object");
                targets[j] = (ManagedObject)ho;
            } else {
                Trace.trace(TRACE_MASKT, " object [" + j + "] is NOT a managed object");
                Trace.trace(TRACE_MASKT, " object is " + ho);
            }
            ++j;
        }
        int i = 0;
        while (i < targets.length) {
            int j2 = 0;
            while (j2 < targetData.size()) {
                ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(targetData, j2);
                if (ads != null) {
                    int k = 0;
                    while (k < ads.length) {
                        ManagedObject[] sobs;
                        if (ads[k].getManagedObject().equals(targets[i]) && (sobs = ads[k].getSecondaryObjects()) != null) {
                            int sobs_index = 0;
                            while (sobs_index < sobs.length) {
                                boolean found_match = false;
                                int soList_index = 0;
                                while (soList_index < secondaryObjects.size() && !found_match) {
                                    ManagedObject mo = (ManagedObject)secondaryObjects.get(soList_index);
                                    if (sobs[sobs_index] == mo) {
                                        found_match = true;
                                    }
                                    ++soList_index;
                                }
                                if (!found_match) {
                                    secondaryObjects.add(sobs[sobs_index]);
                                }
                                ++sobs_index;
                            }
                        }
                        ++k;
                    }
                }
                ++j2;
            }
            ++i;
        }
        ManagedObject[] MOs = null;
        if (secondaryObjects.size() > 0) {
            MOs = new ManagedObject[secondaryObjects.size()];
            MOs = secondaryObjects.toArray(MOs);
        }
        if (MOs != null) {
            Trace.trace(TRACE_MASKT, "<- ActivationCT.checkSecondaryTargets() = " + MOs.length + " returned Secondary Objects");
        } else {
            Trace.trace(TRACE_MASKT, "<- ActivationCT.checkSecondaryTargets() = 0 returned Secondary Objects");
        }
        return MOs;
    }

    public LocalizableText[] getConfirmationTexts(ManagedObject[] targets) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.getConfirmationTexts() ");
        LocalizableText[] text = null;
        if (this.getName().equals("base.task.deactivate")) {
            text = new LocalizableText[targets.length];
            LocalizableText badObjectText = new LocalizableText(" ");
            ActivationCTData actd = new ActivationCTData();
            ArrayList targetData = actd.getTargetData(null);
            if (targetData != null) {
                Trace.trace(TRACE_MASKD, "  Got target data  ");
                int numObjects = 0;
                int j = 0;
                while (j < targetData.size()) {
                    ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(targetData, j);
                    if (ads != null) {
                        numObjects += ads.length;
                    }
                    ++j;
                }
                text = new LocalizableText[numObjects];
                int i = 0;
                while (i < targets.length) {
                    int j2 = 0;
                    while (j2 < targetData.size() && text[i] == null) {
                        ActivationDataForApp[] ads = ActivationCTData.getTargetListForN(targetData, j2);
                        if (ads != null) {
                            int k = 0;
                            while (k < ads.length) {
                                if (ads[k].getManagedObject().equals(targets[i])) {
                                    text[i] = ads[k].getConfirmationText();
                                    Trace.trace(TRACE_MASKD, "  Name = " + ads[k].getManagedObject().getName());
                                    if (text[i] != null) {
                                        Trace.trace(TRACE_MASKD, "  text[" + i + "] = " + text[i].toString());
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j2;
                    }
                    if (text[i] == null) {
                        text[i] = badObjectText;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < text.length) {
                    text[i] = new LocalizableText("");
                    ++i;
                }
                HException hexc = new HException("Error getting saved data");
                new FrameworkLog(ActivateErrorIDs.LOGINFO, 18183, hexc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- ActivationCT.getConfirmationTexts() ");
        return text;
    }

    public void updateTasksPerformed(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.updateTasksPerformed() ");
        if (this.getName().equals("base.task.deactivate")) {
            Trace.trace(TRACE_MASKF, "  Deactivate case; about to call super.updateTasksPerformed()");
            super.updateTasksPerformed(parms);
        }
        Trace.trace(TRACE_MASKT, "<- ActivationCT.updateTasksPerformed() ");
    }

    public void updateTasksPerformedAlways(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKT, "-> ActivationCT.updateTasksPerformedAlways() ");
        Trace.trace(TRACE_MASKD, "  PresentationTaskParms = " + parms);
        super.updateTasksPerformed(parms);
        Trace.trace(TRACE_MASKT, "<- ActivationCT.updateTasksPerformedAlways() ");
    }
}

